/**
*    Particle.h
*    
*    Class to calculate the motion of a particle moving through space.
*    
*    Program written by Lopuz3
*    Spring 2013 
**/

#ifndef Particle_h
#define Particle_h

#include "Arduino.h"

class Particle
{
	public:
		Particle(float x, float y, float z, float vX, float vY, float vZ, boolean bounces, float radius, int cubeSize);
		Particle();
		void move(float dt);
		void accelerateZ(float aZ, float dt);
		void accelerate(float aX, float aY, float aZ, float dt);
		void drag(float coef, float dt);
		int getRoundedX();
		int getRoundedY();
		int getRoundedZ();
		boolean pointIsInSphere(byte x, byte y, byte z);
	private:
		float _x, _y, _z, _vX, _vY, _vZ;
		float _radius;
		boolean _bounces;
		int _cubeSize;
};
#endif